/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.aiff.AiffTag;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class ID3Chunk
extends Chunk {
    private AiffTag aiffTag;

    public ID3Chunk(ChunkHeader hdr, RandomAccessFile raf, AiffTag tag) {
        super(raf, hdr);
        this.aiffTag = tag;
    }

    @Override
    public boolean readChunk() throws IOException {
        AbstractID3v2Tag id3Tag;
        if (!this.isId3v2Tag()) {
            return false;
        }
        int version = this.raf.read();
        switch (version) {
            case 2: {
                id3Tag = new ID3v22Tag();
                AudioFile.logger.finest("Reading ID3V2.2 tag");
                break;
            }
            case 3: {
                id3Tag = new ID3v23Tag();
                AudioFile.logger.finest("Reading ID3V2.3 tag");
                break;
            }
            case 4: {
                id3Tag = new ID3v24Tag();
                AudioFile.logger.finest("Reading ID3V2.4 tag");
                break;
            }
            default: {
                return false;
            }
        }
        this.aiffTag.setID3Tag(id3Tag);
        this.raf.seek(this.raf.getFilePointer() - 4L);
        byte[] buf = new byte[(int)this.bytesLeft];
        this.raf.read(buf);
        ByteBuffer bb = ByteBuffer.allocate((int)this.bytesLeft);
        bb.put(buf);
        try {
            id3Tag.read(bb);
        }
        catch (TagException e) {
            AudioFile.logger.info("Exception reading ID3 tag: " + e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    public void parse(byte[] rawdata, AiffTag aiffTag) throws IOException, CannotReadException {
    }

    private boolean isId3v2Tag() throws IOException {
        byte[] buf = new byte[3];
        this.raf.read(buf);
        String id = new String(buf, "ASCII");
        return "ID3".equals(id);
    }
}

